/*! *********************************************************************************
* Copyright (c) 2015, Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
* All rights reserved.
*
* \file
*
* SPDX-License-Identifier: BSD-3-Clause
********************************************************************************** */

#ifndef __UART_H__
#define __UART_H__


/************************************************************************************
*************************************************************************************
* Include
*************************************************************************************
************************************************************************************/
#include "EmbeddedTypes.h"
#include "main.h"
#ifdef USE_USART
#include "fsl_usart.h"
#endif
/************************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
************************************************************************************/
#ifndef gBoot_UseUart_d
#define gBoot_UseUart_d 1
#endif

#ifndef gBoot_UseUartCalibration_d
#define gBoot_UseUartCalibration_d 0
#endif


/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/


/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/
void uart_init(void (*calback)(uint32_t), uint32_t param);
uint16_t uart_read(uint8_t* pData, uint16_t count);
void uart_sync_write(uint8_t* pData, uint16_t count);

#endif
